/*
 * Decompiled with CFR 0.152.
 */
public class Float {
    private static final Float ERROR = new Float(Long.MAX_VALUE, Long.MAX_VALUE);
    private static final int ITNUM = 5;
    public static final Float SQRT3 = new Float(1732050807568877294L, -18L);
    public static final Float PI = new Float(3141592653589793238L, -18L);
    public static final Float ZERO = new Float();
    public static final Float ONE = new Float(1L);
    public static final Float E = new Float(271828182845904512L, -17L);
    public static final Float LOG10 = new Float(2302585092994045684L, -18L);
    public static final Float PIdiv2 = PI.Div(2L);
    public static final Float PIdiv4 = PIdiv2.Div(2L);
    public static final Float PIdiv6 = PIdiv2.Div(3L);
    public static final Float PIdiv12 = PIdiv6.Div(2L);
    public static final Float PImul2 = PI.Mul(2L);
    public static final Float PImul4 = PI.Mul(4L);
    public long m_Val;
    public long m_E;
    private long maxLimit = 92233720368547758L;

    public Float() {
        this.m_E = 0L;
        this.m_Val = 0L;
    }

    public Float(long l) {
        this.m_Val = l;
        this.m_E = 0L;
    }

    public Float(long l, long l2) {
        this.m_Val = l;
        this.m_E = this.m_Val == 0L ? 0L : l2;
    }

    public Float(Float float_) {
        this.m_Val = float_.m_Val;
        this.m_E = this.m_Val == 0L ? 0L : float_.m_E;
    }

    public long toLong() {
        long l = this.m_E;
        long l2 = this.m_Val;
        while (l != 0L) {
            if (l < 0L) {
                l2 /= 10L;
                ++l;
                continue;
            }
            l2 *= 10L;
            --l;
        }
        return l2;
    }

    public String toShortString() {
        if (this.isError()) {
            return "NaN";
        }
        Long l = new Long(this.m_Val);
        String string = l.toString();
        int n = string.length() + (int)this.m_E;
        if (this.m_Val < 0L ? n > 1 : n > 0) {
            return string.substring(0, n);
        }
        return "0";
    }

    public boolean isError() {
        return this.m_Val == Float.ERROR.m_Val && this.m_E == Float.ERROR.m_E;
    }

    public String toString() {
        if (this.isError()) {
            return "NaN";
        }
        this.RemoveZero();
        Long l = new Long(this.m_Val);
        String string = l.toString();
        int n = string.length();
        boolean bl = false;
        if (this.m_Val < 0L) {
            bl = true;
            string = string.substring(1, n);
            --n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_E < 0L) {
            int n2 = (int)Math.abs(this.m_E);
            if (n2 < n) {
                stringBuffer.append(string.substring(0, n - n2));
                stringBuffer.append(".");
                stringBuffer.append(string.substring(n - n2));
            } else {
                stringBuffer.append(string);
                for (int i = 0; i < n2 - n; ++i) {
                    stringBuffer.insert(0, "0");
                }
                stringBuffer.insert(0, "0.");
            }
        } else if ((long)n + this.m_E > 6L) {
            stringBuffer.append(string.charAt(0));
            if (string.length() > 1) {
                stringBuffer.append(".");
                stringBuffer.append(string.substring(1));
            } else {
                stringBuffer.append(".0");
            }
            stringBuffer.append("E" + ((long)(n - 1) + this.m_E));
        } else {
            stringBuffer.append(string);
            int n3 = 0;
            while ((long)n3 < this.m_E) {
                stringBuffer.append("0");
                ++n3;
            }
        }
        string = stringBuffer.toString();
        stringBuffer = null;
        if (bl) {
            string = "-" + string;
        }
        return string;
    }

    public Float Add(Float float_) {
        if (float_.Equal(ZERO)) {
            return new Float(this);
        }
        long l = this.m_E;
        long l2 = float_.m_E;
        long l3 = this.m_Val;
        long l4 = float_.m_Val;
        while (l != l2) {
            if (l > l2) {
                if (Math.abs(l3) < this.maxLimit) {
                    l3 *= 10L;
                    --l;
                    continue;
                }
                l4 /= 10L;
                ++l2;
                continue;
            }
            if (l >= l2) continue;
            if (Math.abs(l4) < this.maxLimit) {
                l4 *= 10L;
                --l2;
                continue;
            }
            l3 /= 10L;
            ++l;
        }
        if (l3 > 0L && l4 > Long.MAX_VALUE - l3 || l3 < 0L && l4 < Long.MIN_VALUE - l3) {
            l3 /= 10L;
            ++l;
            l4 /= 10L;
            ++l2;
        }
        if (l3 > 0L && l4 > Long.MAX_VALUE - l3) {
            return new Float(ERROR);
        }
        if (l3 < 0L && l4 < Long.MIN_VALUE - l3) {
            return new Float(ERROR);
        }
        return new Float(l3 + l4, l);
    }

    public Float Sub(Float float_) {
        if (float_.Equal(ZERO)) {
            return new Float(this.m_Val, this.m_E);
        }
        return this.Add(new Float(-float_.m_Val, float_.m_E));
    }

    public Float Mul(long l) {
        return this.Mul(new Float(l, 0L));
    }

    public Float Mul(Float float_) {
        boolean bl;
        boolean bl2;
        if (float_.Equal(ZERO) || this.Equal(ZERO)) {
            return new Float(ZERO);
        }
        if (float_.Equal(ONE)) {
            return new Float(this);
        }
        boolean bl3 = bl2 = this.m_Val < 0L;
        if (bl2) {
            this.m_Val = -this.m_Val;
        }
        boolean bl4 = bl = float_.m_Val < 0L;
        if (bl) {
            float_.m_Val = -float_.m_Val;
        }
        while (true) {
            if (float_.m_Val > this.m_Val) {
                if (Long.MAX_VALUE / this.m_Val >= float_.m_Val) break;
                float_.m_Val /= 10L;
                ++float_.m_E;
                continue;
            }
            if (Long.MAX_VALUE / float_.m_Val >= this.m_Val) break;
            this.m_Val /= 10L;
            ++this.m_E;
        }
        if (bl2) {
            this.m_Val = -this.m_Val;
        }
        if (bl) {
            float_.m_Val = -float_.m_Val;
        }
        long l = this.m_E + float_.m_E;
        long l2 = this.m_Val * float_.m_Val;
        return new Float(l2, l);
    }

    public Float Div(long l) {
        return this.Div(new Float(l, 0L));
    }

    public Float Div(Float float_) {
        if (float_.Equal(ONE)) {
            return new Float(this);
        }
        long l = this.m_E;
        long l2 = float_.m_E;
        long l3 = float_.m_Val;
        if (l3 == 0L) {
            return new Float(ERROR);
        }
        long l4 = this.m_Val;
        if (l4 == 0L) {
            return new Float(ZERO);
        }
        long l5 = 0L;
        while ((l4 %= l3) != 0L && Math.abs(l5 += l4 / l3) <= 0xCCCCCCCCCCCCCCCL) {
            if (Math.abs(l4) > 0xCCCCCCCCCCCCCCCL) {
                l3 /= 10L;
                ++l2;
            } else {
                l4 *= 10L;
                --l;
            }
            l5 *= 10L;
        }
        Float float_2 = new Float(l5, l - l2);
        float_2.RemoveZero();
        return float_2;
    }

    public void RemoveZero() {
        if (this.m_Val == 0L) {
            return;
        }
        while (this.m_Val % 10L == 0L) {
            this.m_Val /= 10L;
            ++this.m_E;
        }
    }

    public boolean Great(Float float_) {
        long l = this.m_E;
        long l2 = float_.m_E;
        long l3 = this.m_Val;
        long l4 = float_.m_Val;
        while (l != l2) {
            if (l > l2) {
                if (Math.abs(l3) < this.maxLimit) {
                    l3 *= 10L;
                    --l;
                    continue;
                }
                l4 /= 10L;
                ++l2;
                continue;
            }
            if (l >= l2) continue;
            if (Math.abs(l4) < this.maxLimit) {
                l4 *= 10L;
                --l2;
                continue;
            }
            l3 /= 10L;
            ++l;
        }
        return l3 > l4;
    }

    public boolean Less(long l) {
        return this.Less(new Float(l, 0L));
    }

    public boolean Less(Float float_) {
        long l = this.m_E;
        long l2 = float_.m_E;
        long l3 = this.m_Val;
        long l4 = float_.m_Val;
        while (l != l2) {
            if (l > l2) {
                if (Math.abs(l3) < this.maxLimit) {
                    l3 *= 10L;
                    --l;
                    continue;
                }
                l4 /= 10L;
                ++l2;
                continue;
            }
            if (l >= l2) continue;
            if (Math.abs(l4) < this.maxLimit) {
                l4 *= 10L;
                --l2;
                continue;
            }
            l3 /= 10L;
            ++l;
        }
        return l3 < l4;
    }

    public boolean Equal(Float float_) {
        long l = this.m_E;
        long l2 = float_.m_E;
        long l3 = this.m_Val;
        long l4 = float_.m_Val;
        if (l3 == 0L && l4 == 0L || l3 == l4 && l == l2) {
            return true;
        }
        long l5 = l - l2;
        if (l5 < -20L || l5 > 20L) {
            return false;
        }
        while (l != l2) {
            if (l > l2) {
                if (Math.abs(l3) < this.maxLimit) {
                    l3 *= 10L;
                    --l;
                    continue;
                }
                l4 /= 10L;
                ++l2;
                continue;
            }
            if (l >= l2) continue;
            if (Math.abs(l4) < this.maxLimit) {
                l4 *= 10L;
                --l2;
                continue;
            }
            l3 /= 10L;
            ++l;
        }
        return l3 == l4;
    }

    public Float Neg() {
        return new Float(-this.m_Val, this.m_E);
    }

    public static Float ceil(Float float_) {
        long l = float_.m_Val;
        if (float_.m_E < 0L) {
            long l2 = 1L;
            if (float_.m_E > -19L) {
                for (long i = 0L; i < -float_.m_E; ++i) {
                    l2 *= 10L;
                }
                l /= l2;
                if (float_.m_Val - (l *= l2) > 0L) {
                    l += l2;
                }
            } else {
                if (l > 0L) {
                    return ONE;
                }
                return ZERO;
            }
        }
        return new Float(l, float_.m_E);
    }

    public static Float floor(Float float_) {
        long l = float_.m_Val;
        if (float_.m_E < 0L) {
            long l2 = 1L;
            if (float_.m_E > -19L) {
                for (long i = 0L; i < -float_.m_E; ++i) {
                    l2 *= 10L;
                }
                l /= l2;
                if (float_.m_Val - (l *= l2) < 0L) {
                    l -= l2;
                }
            } else {
                if (l < 0L) {
                    return ONE.Neg();
                }
                return ZERO;
            }
        }
        return new Float(l, float_.m_E);
    }

    public static Float abs(Float float_) {
        if (float_.m_Val < 0L) {
            return float_.Neg();
        }
        return new Float(float_);
    }

    public static Float Int(Float float_) {
        long l = float_.m_Val;
        if (float_.m_E < 0L) {
            long l2 = 1L;
            if (float_.m_E > -19L) {
                for (long i = 0L; i < -float_.m_E; ++i) {
                    l2 *= 10L;
                }
                l /= l2;
                l *= l2;
            } else {
                return ZERO;
            }
        }
        return new Float(l, float_.m_E);
    }

    public static Float Frac(Float float_) {
        return float_.Sub(Float.Int(float_));
    }
}

